; GPS330.ASM 05AUG04 - COPYRIGHT JOHN BECKER - EPE GPS TEST amended as per Readout Sept 04

;PIC16F877, 3.6864MHz, WDT OFF, POR ON, XTAL HS

;PROGRAM WRITTEN IN TASM - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F877 data sheet

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)

        List P = 16F877, R=DEC;
        __CONFIG   h'3F31'

        include P16F877.inc

        CBLOCK
LOOP        ; loop counter
LOOPA       ; loop counter used by LCD
RSLINE      ; LCD command/data flag
CLKCNT      ; pre-counter for seconds
STORE
STORE1
GPSLOOP     ; temp loop for simulation with data in eeprom
CHECKSUM
VALIDITY
DISPLAYCOUNT
LETTER
LETTERCOUNT
STARTCOUNT
TIMEOUT
TIMEOUT2
TIMEOUT3
	ENDC

        CBLOCK H'70'
PROMVAL
	ENDC

MEM1:       .EQU $10  ; first data memory location for Bank 2 (at $120)

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

TABLCD: addwf PCL,F      ;LCD initialisation table
        retlw %00110011  ;initialise lcd - first byte
        retlw %00110011  ;2nd byte (repeat of first)
        retlw %00110010  ;set for 4-bit operation
        retlw %00101100  ;set for 2 lines
        retlw %00000110  ;set entry mode to increment each address
        retlw %00001100  ;set display on, cursor off, blink off
        retlw %00000001  ;clear display
        retlw %00000010  ;return home, cursor & RAM to zero
                         ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'W'
        retlw 'A'
        retlw 'I'
        retlw 'T'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'S'
        retlw 'I'
        retlw 'G'
        retlw 'N'
        retlw 'A'
        retlw 'L'
        retlw ' '
        retlw ' '

MESSAG2: addwf PCL,F
        retlw 'F'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '
        retlw 'G'
        retlw 'P'
        retlw 'S'
        retlw ' '
        retlw 'M'
        retlw 'O'
        retlw 'D'
        retlw 'U'
        retlw 'L'
        retlw 'E'
        retlw ' '


TABLELETTER: movf LETTERCOUNT,W
        addwf STARTCOUNT,W
        addwf PCL,F   ; sentence ID table
        retlw '$'
        retlw 'G'
	retlw 'P'
	retlw 'R'
	retlw 'M'
	retlw 'C'

        retlw '$'
	retlw 'G'
	retlw 'P'
	retlw 'G'
	retlw 'G'
	retlw 'A'
        retlw '#'

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE

        BANK1
        clrf TRISB
        clrf TRISA
        movlw 255
        movwf TRISC
        clrf TRISD
        clrf TRISE
        movlw %00000111  ; set timer ratio 1:256, pull-ups on
        movwf OPTION_REG
        BANK0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON
        call PAUSIT

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWMSG2: movf LOOP,W
        call MESSAG2
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG2

        call SETCGRAM
        clrf VALIDITY
        clrf DISPLAYCOUNT
        clrf TIMEOUT
        clrf TIMEOUT2
        movlw 254
        movwf TIMEOUT3
        call SETBAUD

; *************** START OF MAIN PROG ***********

MAIN:   call FlushRXBuffer      ; Make sure that the RX buffer is empty
        clrf STARTCOUNT
        call GETSENTENCE
        call DECODEGPRMC
        movlw 6
        movwf STARTCOUNT
        call GETSENTENCE
        call DECODEGPGGA

PAGECHANGE: incf DISPLAYCOUNT,F  ; check if LCD page is to be changed
        movf DISPLAYCOUNT,W
        andlw %00011111
        xorlw %00000100
        btfss STATUS,Z
        goto BACKIT
        movlw 16
        movwf LOOP

FORWARDS: movlw %00011000
        call LCDLIN
        decfsz LOOP,F
        goto FORWARDS
        goto MAIN

BACKIT: movf DISPLAYCOUNT,W
        andlw %00011111
        xorlw %00001000
        btfss STATUS,Z
        goto MAIN
        movlw 16
        movwf LOOP

BACK2:  movlw %00011100
        call LCDLIN
        decfsz LOOP,F
        goto BACK2
        clrf DISPLAYCOUNT
        goto MAIN

;*****************

SUMIT:  bcf RCSTA,CREN    ; turn off reception
        clrf CHECKSUM
        movlw MEM1
        addlw 1
        movwf FSR

CHECKIT: BLOCK1           ; do checksum
        movf INDF,W
        BLOCK0
        xorlw '*'
        btfsc STATUS,Z
        goto CHECK2
        xorlw '*'	; new line 05AUG04
        xorwf CHECKSUM,F
        incf FSR,F
        movf FSR,W
        xorlw $6F
        btfss STATUS,Z
        goto CHECKIT
        goto EOFPROBLEM

CHECK2: incf FSR,F
        BLOCK1
        movf INDF,W       ; get first digit of checksum
        BLOCK0
        movwf PROMVAL     ; and convert to decimal, storing full conversion in PROMVAL
        movlw 48          
        subwf PROMVAL,F
        movf PROMVAL,W    ; is val >9?
        addlw 246		;val amended from 247 05Aug04
        btfss STATUS,C
        goto CHECKV1      ; no
        movlw 7           ; yes (it's between A and F)
        subwf PROMVAL,F   ; subtract 7 

CHECKV1: incf FSR,F
        BLOCK1
        movf INDF,W       ; get 2nd digit of checksum
        BLOCK0
        movwf STORE
        movlw 48
        subwf STORE,F
        movf STORE,W      ; is val >9?
        addlw 246		;val amended from 247 05Aug04
        btfss STATUS,C
        goto CHECKV2      ; no
        movlw 7           ; yes (it's between A and F)
        subwf STORE,F     ; subtract 7 

CHECKV2: swapf PROMVAL,W
        addwf STORE,W
        movwf PROMVAL

        movf CHECKSUM,W   ; compare actual checksum with expected (in PROMVAL)
        xorwf PROMVAL,W   ; are both vals equal?
        btfss STATUS,Z
        goto CHECKSUMPROBLEM      ; no
        return

;********** LCD CONTROL SECTION *********

LCD1:   movlw %10000000
        goto LCDLIN
LCD16:  movlw %10010000
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN
LCD29:  movlw %11001001
        goto LCDLIN

LCD216: movlw %11010000
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 255       ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 14        ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

SETCGRAM: movlw %01000000  ;set address for CG RAM write to 0
        call LCDLIN
        bsf RSLINE,4

        movlw %00011100    ; put degree symbol into CGRAM 0
        call LCDOUT
	movlw %00010100
        call LCDOUT
	movlw %00011100
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	return

; ***************        

SETBAUD
        bcf STATUS,RP1
        bsf STATUS,RP0
        movlw   d'42'           ; 4800 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
;        movlw   d'47'           ; 4800 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)

;        movlw 23                ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
;        movlw 20                ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        clrf STORE
        bsf STORE,SPEN
        movf STORE,W
        movwf   RCSTA           ; In bank 0
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop: nop
        incfsz TIMEOUT,F
        goto Rec2
        incfsz TIMEOUT2,F
        goto Rec2
        incfsz TIMEOUT3,F
        goto Rec2
        call TIMEOUTMSG

Rec2:   btfss   PIR1,RCIF       ; Check for any RX'd data
        goto RecLoop
        clrf TIMEOUT
        clrf TIMEOUT2
        movlw 254
        movwf TIMEOUT3
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

CHECKSUMPROBLEM:
        call LCD21
        call CHECKP2
        call LCD216
        call CHECKP2
        return

CHECKP2: movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw '!'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        goto MAIN

EOFPROBLEM: call LCD21
        call EOF2
        call LCD216
        call EOF2
        return

EOF2:   movlw 'N'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'F'
        movlw '!'
        call LCDOUT
        movlw ' '
        call LCDOUT
        goto MAIN

; ************* GET DATA SENTENCE FROM GPS *********

GETSENTENCE:

WAIT1:  movlw MEM1
        movwf FSR               ; set FSR to address of MEM1
        clrf LETTERCOUNT
        call TABLELETTER
        movwf LETTER
        bsf RCSTA,CREN          ; turn on reception
        call FlushRXBuffer      ; Make sure that the RX buffer is empty

WAIT2:  call RecLoop            ; Wait and read from serial - character returned in W
        BLOCK1
        movwf INDF              ; store received byte to INDF
        BLOCK0
        subwf LETTER,W          ; is this the required letter?
        btfss STATUS,Z
        goto Wait1              ; no, so start afresh

        incf FSR,F              ; yes, get next byte
        incf LETTERCOUNT,F      ; inc lettercount, is it = 6?
        call TABLELETTER
        movwf LETTER
        movf LETTERCOUNT,W
        xorlw 6
        btfss STATUS,Z
        goto WAIT2

GETTEXT: call RecLoop           ; Wait and read from serial - character returned in W
        BLOCK1
        movwf INDF              ; store received byte to INDF
        BLOCK0
        movwf STORE
        incf FSR,F
        movf FSR,W              ; has FSR reached max? (unlikely, but possible event)
        xorlw $6F
        btfsc STATUS,Z
        goto DOCHECKSUM         ; yes

        movf STORE,W
        sublw 13                ; Is this 13 ?
        btfss STATUS,Z
        goto GETTEXT            ; Not 13

DOCHECKSUM: call SUMIT
        movlw MEM1
        addlw 7
        movwf FSR
        movwf GPSLOOP
        return

;************ DECODE GPRMC SENTENCE AND PLACE REQUIRED DATA INTO LCD ****

DECODEGPRMC:
        call LCD1
Gtime:  BLOCK1                  ; show time
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw ':'
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw '.'
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw ' '
        call LCDOUT
        incf FSR,F              ; inc to bypass comma

GAcheck: incf FSR,F             ; Validity check
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf VALIDITY
        call LCDOUT
        incf FSR,F              ; inc to bypass comma

Glat:   call LCD16              ; show latitude
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw 0
        call LCDOUT
        incf FSR,F

Glat3:  BLOCK1     
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto GNS                ; yes, equals comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        goto Glat3

GNS:    incf FSR,F            ; inc to bypass comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT           ; show N/S
        incf FSR,F            ; inc to bypass comma

        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf VALIDITY,W
        call LCDOUT

Glong:  call LCD216           ; show longitude
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw 0
        call LCDOUT
        incf FSR,F

Glong3: BLOCK1     
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto GWE                ; yes, equals comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        goto Glong3

GWE:    incf FSR,F            ; inc to bypass comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT           ; show W/E
        incf FSR,F            ; inc to bypass comma

Knots:  incf FSR,F
        BLOCK1                  ; bypass speed
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfss STATUS,Z
        goto Knots

Course: incf FSR,F              ; inc to bypass comma
        BLOCK1                  ; bypass course
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfss STATUS,Z
        goto Course

Gdate:  call LCD21              ; yes, equals comma
        incf FSR,F
        BLOCK1                  ; show date
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw ':'
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw ':'
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

;************ DECODE GPGGA SENTENCE AND PLACE REQUIRED DATA INTO LCD ****

DECODEGPGGA:
        call LCD29
        movlw 8
        movwf LOOP

H1:     incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto H2                 ; yes, equals comma
        goto H1

H2:     decfsz LOOP,F
        goto H1
        incf FSR,F

Height: BLOCK1
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto HT2                ; yes, equals comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT
        incf FSR,F
        goto Height

HT2:    incf FSR,F            ; inc to bypass comma
        BLOCK1
        movf INDF,W
        BLOCK0
        call LCDOUT           ; show letter
        movlw ' '
        call LCDOUT
        return

TIMEOUTMSG:
        clrf LOOP
        call LCD1
        bsf RSLINE,4
TIMEMSG: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TIMEMSG

        clrf LOOP
        call LCD16
        bsf RSLINE,4
TIMEMSG2: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TIMEMSG2
        return

        END

